function [R,t] = RtXu_ba( R0, t0, K, X, u )
%RTXU_BA  Nonlinear iterative refinement of calibrated single view resection.
%
%   [R t] = RtXu_ba( R, t, K, X, u )
%
%   TODO
%
%   Input:
%     R, t, K  .. single view orientation and internal
%                 calibration, P = K * [ R | t ]
%     X        .. spatial points, projective (4xn)
%     u        .. corresponding projections of X, euclidean (2xn)
%
%   Output:
%     R, t  .. updated orientation.

% (c) 2009-01-08, Martin Matousek
% Last change: $Date::                            $
%              $Revision$

a0 = R2aa( R0 );  % axis-angle representation

x0 = [a0;t0];

x = levmar( x0, @fun, @gHfun, ...
            { 'verbose', 1, 'dfmin', 0.01, ...
              'maxiter', 5 }, ...
            K, X, u );

R = a2R( x(1:3) ); 
assert( isreal( R ) );
t = x(4:6);

% ------------------------------------------------------------------------------
% gradient

function [g H] = gHfun( x, K, X, u )
[delta_z J] = dz_jaco( x, K, X, u ); % 2n x 6
g = J' * delta_z(:); 
H = J' * J;

% ------------------------------------------------------------------------------
% objective function

function f = fun( x, K, X, u )
delta_z = dz( x, K, X, u ); % 2xn
fi = 0.5 * sum( delta_z.^2 ); 
f = sum( fi );

% ------------------------------------------------------------------------------
% residues and Jacobian of residues, evaluated numerically

function [err0, J] = dz_jaco( x0, K, X, u )
nX = size( u, 2 ); 
ncam = 1;
nz = nX * ncam * 2; % 2 - two image coordinates

err0 = dz( x0, K, X, u );

delta = 1e-4;

J = zeros( nz, 6 );
for i = 1:6
  x = x0;
  x(i) = x(i) + delta;
  j = ( dz( x, K, X, u ) - err0 ) / delta;
  J(:,i) = j(:);
end

% ------------------------------------------------------------------------------
% residues

function err = dz( x, K, X, u )
n = size( u, 2 ); 

R = a2R( x(1:3) ); 
t = x(4:6);

ux = K * [ R t ] * X;

err = [ux(1,:) ./ ux(3,:); ux(2,:) ./ ux(3,:)] - u;
